function Nph = get_trabi(allspots,radius,Nbg,parameters)

% Aperture photometry (trabi)
% This function estimates the number of signal photon within a circular
% aperture. The background photons per pixel is taken as input.

[Nxpixels,Nypixels,Mz] = size(allspots);
pixelsize = parameters.pixelsize;
xrange = pixelsize*Nxpixels/2;
yrange = pixelsize*Nypixels/2;
ImageSizex = xrange;
ImageSizey = yrange;
% image coordinate sampling (in physical length units)
DxImage = 2*ImageSizex/Nxpixels;
DyImage = 2*ImageSizey/Nypixels;
ximagelin = -ImageSizex+DxImage/2:DxImage:ImageSizex;
yimagelin = -ImageSizey+DyImage/2:DyImage:ImageSizey;
[YImage,XImage] = meshgrid(yimagelin,ximagelin);

Nph = zeros(Mz,1);

% Define aperture
% A1area    = pi*radius^2;    % area of aperture
A1mask = double((XImage.^2+YImage.^2)<(radius*pixelsize)^2); % mask aperture
NpxA1 = sum(sum(A1mask(:,:,1))); % number of pixels aperture

% do aperture photometry
for jj = 1:Mz
    
    spot = allspots(:,:,jj);
    
    % 1) The aperture is used to determine the raw intensity (Iraw) by
    % integrating the signal over all pixels within the area A1
    Iraw = squeeze(sum(sum(A1mask.*spot)));
    
    % 2) Assume background is known 
    % empty 
    
    % 3) Finally, the corrected intensity is calculated as
    Nph(jj,:) = Iraw-Nbg.*NpxA1;
    
end

end
